function Menu()
{
  while (AreKeysLeft()){ GetKey(); }
  if (this instanceof Menu == false) {
    return new Menu();
  }

  // default properties
  this.font = GetSystemFont();
  this.window_style = GetSystemWindowStyle();
  this.arrow = LoadImage("testmoust.png");
  this.up_arrow = GetSystemUpArrow();
  this.down_arrow = GetSystemDownArrow();
  this.escape_function = function() { }
  this.allow_escape = true;
  this.select_menu = false;
  this.Render = function() { }
  this.selection = 0;
  this.indexes = 0;
  this.items = new Array();
}

// add item
Menu.prototype.addItem = function(name, callback) {
  var item = new Object;
  item.name      = name;
  item.callback  = callback;
  this.items[this.items.length] = item;
}

// execute
Menu.prototype.execute = function(x, y, w, h) {
  with (this) {
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());   

    var text_height = font.getHeight();
    var shown_items = Math.floor(h / text_height);

    var selection = this.selection;
    var top_selection = 0;
    

    while (true) {
      var item = items[selection];
      // draw background
      background.blit(0, 0);

      // draw the window
      window_style.drawWindow(x, y, w, h);
      
      // draw the menu items
      for (var i = 0; i < shown_items; i++) {
        if (i < items.length) {
          font.drawText(x + 16 + 1, y + i * text_height + 4, items[i + top_selection].name);
        }
      }   

      // draw the selection arrow
      arrow.blit(x, y + (selection - top_selection) * text_height);
           
      // draw the up and down arrows if necessary
      if (top_selection > 0) {
        up_arrow.blit(x + w - up_arrow.width, y);
      }
      if (top_selection + shown_items < items.length) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items - down_arrow.height);
        
     }

      // Render
      Render();  
      // auto grab 
      back = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight()); 
      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_CTRL: {            
            selected_enemy = selection;  // Which enemy for the battle.
            selected_player = selection;  //  Which player for the battle.
             if (allow_escape == true) menu_accept_sound.play (false);  
            item.callback();
             return;
          }

          case KEY_ALT: {
           if (allow_escape == true)
           { 
             if (select_menu == true ) {
               Member[Last_Chosen].battle_used = false;
             }
             if (allow_escape == true) menu_cancel_sound.play (false);  
             escape_function();
             return;
           }
           else
           {
             if (allow_escape == true) menu_cancel_sound.play (false);  
             break;
           }
          }

          case KEY_DOWN: 
          {
             if (selection < items.length - 1) {
              selection++;         
              menu_sound.play (false);  
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
              selection--;
              menu_sound.play (false);
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }

          

        }
      } // end handle input
    }

  } // end with
}

/*********************************************************************/

var Item_Grab = new Array;

function Game_Menu()
{  
  RenderMap();
    
  win_main.drawWindow (10,10,110,10);
  Text(45,10,"Menu");
  
  win_main.drawWindow (10,124,110,10);
  Text (16,125,"Gold: $" + Gold);
  
  var menu = new Menu();
  menu.addItem ("Continue", t);
  menu.addItem ("Stats", Status_Menu); 
  menu.addItem ("Items", Item_Menu); 
  menu.addItem ("Equip", Equip_Menu); 
  menu.addItem ("Quit", function(){ Abort("Good bye!");  }); 
  
  menu.Render = function()
  {
    Item_Grab[0] = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());
  }
  menu.execute (10, 40, 110, 64);
     
}

// -----------------------------------------//
//                    Status Menu

function Status_Menu()
{  
  RenderMap();

  Item_Grab[0].blit (0,0); 
  win_main.drawWindow (70,30,90,10);
  Text (97,30,"Stats");
    
  var menu = new Menu();
  
  for (i = 0; i < Member.length; i++)
  {
    if (Member[i].used == true)
    {
       menu.addItem (Member[i].name, new Function("Player_Stats("+i+")") );
    }
  }

  menu.escape_function = function(){ Game_Menu(); }
  menu.execute (70, 60, 90, 80);
}

function Player_Stats(who)
{  
  RenderMap();

  while(IsKeyPressed(KEY_ALT) == false)
  {
    back.blit (0,0);
    
    win_main.drawWindow (50,75,GetScreenWidth()-100,GetScreenHeight()-90);
    Text (60,80, Member[who].name);
    Text (60,100, "Health:  " + Member[who].hp + "/" + Member[who].maxhp);
    Text (60,120, "Magic:  " + Member[who].mp + "/" + Member[who].maxmp);
    Text (60,140, "ATK: " + Member[who].atk);
    Text (60,160, "DEF: " + Member[who].def);
    Text (60,180, "Weapon: " + Weapons[Member[who].weapon].name);
    Text (60,200, "Armor: " + Armors[Member[who].armor].name);
    Text (160,80, "Level " + Member[who].level);
        
    FlipScreen();
    if (AreKeysLeft()){  GetKey();  }
  }   

  Status_Menu();
}

// -----------------------------------------//
//                    Item Menu

function Item_Menu()
{  
  RenderMap();

  Item_Grab[0].blit (0,0); 
  win_main.drawWindow (80, 25,140,10);  
  Text (104,25,"Items");
  win_main.drawWindow (50,155,GetScreenWidth()-100,40); 
  
  var menu = new Menu();
  var indexes = new Array;
  
  for (i = 0; i < Items.length; i++)
  {
    if (Items[i].ammount > 0)
    {
       indexes.push(Items[i]);
       menu.addItem (Items[i].name + ": " + Items[i].ammount, new Function("Remember_Item = "+i+"; Choose_Player_Items();") );     
       menu.Render = function()
       {          
         if (menu.items[menu.selection].name != "Cancel") fnt_main.drawTextBox(53,159,GetScreenWidth()-100,40, 0, indexes[menu.selection].name + ": " + indexes[menu.selection].description); 
         else fnt_main.drawTextBox(53,159,GetScreenWidth()-100,40, 0, "Cancel");
         Item_Grab[1] = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());
       }
    } 
  }
  
  menu.indexes = indexes;  
  menu.addItem ("Cancel", Game_Menu);
  menu.escape_function = function(){ Game_Menu(); }
  menu.execute (80, 55, 140, 80);
}

function Choose_Player_Items()
{
  RenderMap();
  Item_Grab[1].blit (0,0); 
  
  win_main.drawWindow (200,160,90, 40);  
  
  win_main.drawWindow (200,42,90,10);
  Text (205,42,"Player");
    
  var menu = new Menu();
  var indexes = new Array;
  
  for (i = 0; i < Member.length; i++)
  {
    if (Member[i].used == true)
    {
       indexes.push(i);
       menu.addItem (Member[i].name, new Function("Last_Chosen = "+i+"; Use_Item(); Item_Menu();") );
    }
  }
  
  menu.indexes = indexes; 
  menu.Render = function()
  { 
    Text(203,163, "HP: " + Member[indexes[menu.selection]].hp + "/" + Member[indexes[menu.selection]].maxhp);
    Text(203,173, "MP: " + Member[indexes[menu.selection]].mp + "/" + Member[indexes[menu.selection]].maxmp);
  }
  menu.escape_function = function(){ Item_Menu(); }
  menu.execute (200, 72, 90, 70);
}

// -----------------------------------------//
//                    Equip Menu

function Equip_Menu()
{  
  RenderMap();
  Item_Grab[0].blit (0,0); 
  win_main.drawWindow (85,25,140,10);
  Text (109,25,"Equipment");
  win_main.drawWindow (50,145,GetScreenWidth()-100,40);
  
  var menu = new Menu();
  var indexes = new Array;
  
  for (i = 0; i < Weapons.length; i++) //Weapons
  {
    if (Weapons[i].ammount > 0)
    {
       indexes.push(Weapons[i]);
       menu.addItem (Weapons[i].name + ": " + Weapons[i].ammount, new Function("Remember_Weapon = "+i+"; Choose_Player_Weapons();") );
       menu.Render = function()
       { 
         if (menu.items[menu.selection].name != "Cancel") fnt_main.drawTextBox (53,149,GetScreenWidth()-100,40, 0, indexes[menu.selection].name + ": " + indexes[menu.selection].description); 
         else fnt_main.drawTextBox(53,159,GetScreenWidth()-100,40, 0, "Cancel");
         Item_Grab[1] = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());
       }
    }
  }
  
    for (i = 0; i < Armors.length; i++) //Armors
  {
    if (Armors[i].ammount > 0)
    {
       indexes.push(Armors[i]);
       menu.addItem (Armors[i].name + ": " + Armors[i].ammount, new Function("Remember_Armor = "+i+"; Choose_Player_Armors();") );
       menu.Render = function()
       { 
         if (menu.items[menu.selection].name != "Cancel") fnt_main.drawTextBox (53,149,GetScreenWidth()-100,40, 0, indexes[menu.selection].name + ": " + indexes[menu.selection].description); 
         else fnt_main.drawTextBox(53,159,GetScreenWidth()-100,40, 0, "Cancel");
         Item_Grab[1] = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());
       } 
    }
  }

  menu.indexes = indexes;
  menu.addItem ("Cancel", Game_Menu);
  menu.escape_function = function(){ Game_Menu(); }
  menu.execute (85, 55, 140, 70);
}

function Choose_Player_Weapons()
{
  RenderMap();
  Item_Grab[1].blit (0,0); 
  
  win_main.drawWindow (50,59,90,10);
  Text (65,60,"Player");
    
  var menu = new Menu();
  
  for (i = 0; i < Member.length; i++)
  {
    if (Member[i].used == true)
    {
       menu.addItem (Member[i].name, new Function("Last_Chosen = "+i+"; Use_Weapon(); Equip_Menu();") );
    }
  }

  menu.escape_function = function(){ Equip_Menu(); }
  menu.execute (50, 90, 90, 70);
}

function Choose_Player_Armors()
{
  RenderMap();
  Item_Grab[1].blit (0,0); 
  
  win_main.drawWindow (50,59,90,10);
  Text (65,60,"Player");
    
  var menu = new Menu();
  
  for (i=0; i<Member.length; i++)
  {
    if (Member[i].used == true)
    {
       menu.addItem (Member[i].name, new Function("Last_Chosen = "+i+"; Use_Armor(); Equip_Menu();") );
    }
  }
  
  menu.addItem ("Cancel", Game_Menu);
  menu.escape_function = function(){ Equip_Menu(); }
  menu.execute (50, 90, 90, 70);
}
